!!ARBvp1.0
# default_shader__TREE.vsh

TEMP r0, r1, r2, r3, r5, r6, r7, r8, r9;

PARAM c[11] = { program.env[0..10] };
PARAM c42 = program.env[42];
PARAM c44 = program.env[44];
PARAM c66 = program.env[66];

PARAM c20 = {0.0, 1.0, 0.5, 2.0};

PARAM c22 = {1.0, 0.0, 0.0, 0.0};
PARAM c23 = {0.0, 1.0, 0.0, 0.0};
PARAM c24 = {0.1, 0.0, 0.0, 0.0};
PARAM c25 = {0.0, 0.0, 0.0, 1.0};

# for sin/cos
PARAM c30 = {3.14159, 0.5, 6.2831853, 0.159154943};
PARAM c31 = {1.0, -0.5, 0.04166667, -0.001388889};
PARAM c32 = {1.0, -0.166667, 0.001388889, -0.0001984126984};

ATTRIB v0 = vertex.position;
ATTRIB v1 = vertex.normal;
ATTRIB v2 = vertex.texcoord[0];

ALIAS oPos = result.position;
ALIAS oD0 = result.color.primary;
ALIAS oT0 = result.texcoord[0];
ALIAS oT1 = result.texcoord[1];

# ---- TREE DEFORMATION ----

SUB r9.x, v0.x, c66.y;
ADD r9.x, c42.w, r9.x;
MOV r9.y, v0.y;
SUB r9.z, v0.z, c66.z;
ADD r9.z, c44.w, r9.z;
MOV r9.w, v0.w;
MAX r0.x, r9.x, r9.z;

MUL r1.x, r0.x, c66.x;
MUL r1.x, r1.x, c20.w;	# KLC - Make it a little more obvious

# scalar r0.x = cos(r1.x), r0.y = sin(r1.x)
MAD r0.x, r1.x, c30.w,  c30.y;  # bring argument into -pi, .., +pi range
EXP r0.y, r0.x;
MAD r0.x, r0.y, c30.z, -c30.x;
DST r2.xy, r0.x, r0.x;		    # generate 1, (r0.x)^2, .. (r0.x)^6
MUL r2.z, r2.y, r2.y;
MUL r2.w, r2.y, r2.z;
MUL r0, r2, r0.x;				# generate r0.x, (r0.x)^3, .., (r0.x)^7
DP4 r0.y, r0, c32;				# compute sin(r0.x)
DP4 r0.x, r2, c31;				# compute cos(r0.x)

MOV r5.x, r0.x;
MOV r5.y, c23.x;
MOV r5.z, -r0.y;
MOV r5.w, c66.y;
SUB r5.w, r5.w, c42.w;

MOV r6, c23;

MOV r7.x, r0.y;
MOV r7.y, c23.x;
MOV r7.z, r0.x;
MOV r7.w, c66.z;
SUB r7.w, r7.w, c44.w;

MOV r8, c25;

DP4 r0.x, r9, r5;
DP4 r0.y, r9, r6;
DP4 r0.z, r9, r7;
DP4 r0.w, r9, r8;

DP3 r1.x, v1, r5;
DP3 r1.y, v1, r6;
DP3 r1.z, v1, r7;

# ---- END TREE DEFORMATION ----

# transform position
DP4 oPos.x, r0, c[0];
DP4 oPos.y, r0, c[1];
DP4 oPos.z, r0, c[2];
DP4 oPos.w, r0, c[3];

# normal dot light
DP3 r0.x, r1, c[8];
MAX r0.x, r0.x, c20.x;

# Make alpha 1.0
MOV r0.w, c20.y;

# Modulate with sun color
MUL r0.xyz, c[9], r0.x;

# Add ambient color
ADD r0, r0, c[10];

# Cap out at 1.0
MIN oD0, r0, c20.yyyy;

# Use directly texcoord0
MOV oT0.xy, v2;
MOV oT1.xy, v2;

END
